﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using System.Text;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using System.IO;
using System.Data;
using System.Drawing.Imaging;
using System.Drawing.Printing;
using Microsoft.Reporting.WebForms;
using VHAReportViewer;
using System.Web.Security.AntiXss;

public partial class LabResultsInterpretation : BasePage, IDisposable

{
    private int OrderType;
    private static int _currentPageIndex;
    private static IList<Stream> _stream;
    private ReportViewerHandler _reportViewerHandler = new ReportViewerHandler();
    private LabResultsIntrprtnManager _letterManager = new LabResultsIntrprtnManager();

    protected void Page_Load(object sender, EventArgs e)
    {
        //TODO - Move breadcrumb logic to menubuilder and master page. Added here to avoid error out in Referral pages.
        int orderType = GetOrderType();
        Helpers.RemoveAllLettersFromPrintQueue();
        if (orderType == (int)WorkflowCaseActivityStatus.New)
        {
            SetLetterBatchPrintingVisible(true);
            List<INTERPRETATION_LETTER> allLettersInQueueFrag = _letterManager.GetAllInterpretationLettersInPrintQueue((int)EfrWorkCaseType.FragmentAnalysis);
            List<INTERPRETATION_LETTER> allLettersInQueueBio = _letterManager.GetAllInterpretationLettersInPrintQueue((int)EfrWorkCaseType.BiologicalMonitoring);
            LETTER_BATCH_PRINTING_STATUS batchPrintStatus = _letterManager.GetBatchPrintingStatus();
            if (allLettersInQueueFrag.Count > 0)
            {
                if (batchPrintStatus != null)
                {
                    ButtonPrintLettersPatientFrag.Enabled = !batchPrintStatus.PATIENT_FRAGMENT_BATCH_PRINTED;
                    ButtonPrintLettersProviderFrag.Enabled = !batchPrintStatus.PROVIDER_FRAGMENT_BATCH_PRINTED;
                }
                else
                {
                    ButtonPrintLettersPatientFrag.Enabled = true;
                    ButtonPrintLettersProviderFrag.Enabled = true;
                }
            }
            else
            {
                ButtonPrintLettersPatientFrag.Enabled = false;
                ButtonPrintLettersProviderFrag.Enabled = false;
            }

            if (allLettersInQueueBio.Count > 0)
            {
                if (batchPrintStatus != null)
                {
                    ButtonPrintLettersPatientBio.Enabled = !batchPrintStatus.PATIENT_BIO_BATCH_PRINTED;
                    ButtonPrintLettersProviderBio.Enabled = !batchPrintStatus.PROVIDER_BIO_BATCH_PRINTED;
                }
                else
                {
                    ButtonPrintLettersPatientBio.Enabled = true;
                    ButtonPrintLettersProviderBio.Enabled = true;
                }
            }
            else
            {
                ButtonPrintLettersPatientBio.Enabled = false;
                ButtonPrintLettersProviderBio.Enabled = false;
            }
        }
        else
        {
            SetLetterBatchPrintingVisible(false);
        }
        if (!IsPostBack)
        {
            BreadCrumbLabel.Text = BreadCrumbLabel.Text + Enum.GetName(typeof(WorkflowCaseActivityStatus), orderType).AddSpacesToCamelCase();
            HiddenFieldClearFlag.Value = "0";
        }
        GridViewLabResultsIntrprtn.DataSourceID = "ObjectDataSource1";
    }

    private void SetLetterBatchPrintingVisible(bool visible)
    {
        ButtonPrintLettersPatientBio.Visible = visible;
        ButtonPrintLettersPatientFrag.Visible = visible;
        ButtonPrintLettersProviderBio.Visible = visible;
        ButtonPrintLettersProviderFrag.Visible = visible;
    }

    protected void ButtonClear_Click(object sender, EventArgs e)
    {
        TextBoxSearchCriteria.Text = String.Empty;
        HiddenFieldClearFlag.Value = "1";
    }

    protected void ButtonOK_Click(object sender, EventArgs e)
    {
        GridViewLabResultsIntrprtn.PageIndex = 0;
        HiddenFieldClearFlag.Value = "0";
    }



    protected void ObjectDataSource1_Selected(object sender, ObjectDataSourceStatusEventArgs e)
    {
        GridViewLabResultsIntrprtn.EmptyDataText = "No records found for the " + Enum.GetName(typeof(WorkflowCaseActivityStatus), GetOrderType()).AddSpacesToCamelCase() + " lab interpretation results.";


    }

    private int GetOrderType()
    {
        if (!IsPostBack)
        {
            OrderType = Convert.ToInt16(AntiXssEncoder.HtmlEncode(Request.QueryString["OrderType"], false));
            ViewState["OrderType"] = OrderType;
        }
        else //For paging
            OrderType = Convert.ToInt16(ViewState["OrderType"]);
        return OrderType;
    }

    protected void SelectActivity(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Details")
        {
            int index = Convert.ToInt32(e.CommandArgument);
            GridViewLabResultsIntrprtn.SelectedIndex = index;
            Int32 CaseId = Convert.ToInt32(GridViewLabResultsIntrprtn.SelectedDataKey.Values[0]);
            int WfType = Convert.ToInt16(GridViewLabResultsIntrprtn.SelectedDataKey.Values[1]);
            if (WfType == Convert.ToInt16(WorkFlowTypes.Biomonitoring))
                Response.Redirect(string.Format("BioLabInterpretation.aspx?CaseId={0}", CaseId));
            if (WfType == Convert.ToInt16(WorkFlowTypes.FragmentAnalysis))
                Response.Redirect(string.Format("FragLabInterpretation.aspx?CaseId={0}", CaseId));
        }
    }

    public override string TopMenuName()
    {
        return "My Tasks";
    }

    public override string MenuItemName()
    {
        return "New";
    }

    public override string AppObjectCode()
    {
        return "EFR_LABINTERPRETATION";
    }

    protected void ButtonPrintLettersProviderBio_Click(object sender, EventArgs e)
    {
        UpdateBatchPrintingStatus(LetterType.ProviderBioMonitoring);
        Response.Redirect(string.Format("LabResultsInterpretationLetters.aspx?activityId=0&intActivityId=0&RptType=12&CaseId=0"));
    }

    protected void ButtonPrintLettersPatientBio_Click(object sender, EventArgs e)
    {
        UpdateBatchPrintingStatus(LetterType.PatientBioMonitoring);
        Response.Redirect(string.Format("LabResultsInterpretationLetters.aspx?activityId=0&intActivityId=0&RptType=11&CaseId=0"));
    }

    protected void ButtonPrintLettersProviderFrag_Click(object sender, EventArgs e)
    {
        UpdateBatchPrintingStatus(LetterType.ProviderFragment);
        Response.Redirect(string.Format("LabResultsInterpretationLetters.aspx?activityId=0&intActivityId=0&RptType=14&CaseId=0"));
    }

    protected void ButtonPrintLettersPatientFrag_Click(object sender, EventArgs e)
    {
        UpdateBatchPrintingStatus(LetterType.PatientFragment);
        Response.Redirect(string.Format("LabResultsInterpretationLetters.aspx?activityId=0&intActivityId=0&RptType=13&CaseId=0"));
    }

    private void UpdateBatchPrintingStatus(LetterType letterType)
    {
        LETTER_BATCH_PRINTING_STATUS batchPrintStatus = _letterManager.GetBatchPrintingStatus();
        if (batchPrintStatus == null)
        {
            batchPrintStatus = new LETTER_BATCH_PRINTING_STATUS();
        }
        batchPrintStatus.SetAsChangeTrackingRoot();
        switch (letterType)
        {
            case LetterType.PatientBioMonitoring:
                batchPrintStatus.PATIENT_BIO_BATCH_PRINTED = true;
                break;
            case LetterType.ProviderBioMonitoring:
                batchPrintStatus.PROVIDER_BIO_BATCH_PRINTED = true;
                break;
            case LetterType.PatientFragment:
                batchPrintStatus.PATIENT_FRAGMENT_BATCH_PRINTED = true;
                break;
            case LetterType.ProviderFragment:
                batchPrintStatus.PROVIDER_FRAGMENT_BATCH_PRINTED = true;
                break;
        }
        if (batchPrintStatus.LETTER_BATCH_PRINTING_STATUS_ID == 0)
        {
            batchPrintStatus.SetAsInsertOnSubmit();
        }
        else
        {
            batchPrintStatus.SetAsUpdateOnSubmit();
        }
        _letterManager.UpdateLetterBatchPrintingStatus(batchPrintStatus);
    }
}
